<?php 
// Garantir que service_type está definido
if (!isset($service_type) && isset($template_service_type)) {
    $service_type = $template_service_type;
} elseif (!isset($service_type) && isset($product_id)) {
    $service_type = get_post_meta($product_id, '_upgram_service_type', true);
} elseif (!isset($service_type)) {
    $service_type = '';
}
?>
<?php if ($posts): ?>
  <?php foreach ($posts as $post): ?>
    <div x-data="{ shortcode: '<?php echo esc_attr($post['shortcode']) ?>'}"
      class="imag-container insta-image"
      @click="selected.includes(shortcode) ? selected.splice(selected.indexOf(shortcode),1) : selected.length + 1 > total / min ? alert('Você não pode selecionar mais fotos.') : selected.push(shortcode)"
      style="position: relative">
      <span class="imag-container cursor-pointer insta-image">
        <img height="155" width="124" src="<?php echo esc_attr($post['base64']); ?>" alt="Instagram post <?php echo esc_attr($post['id']); ?>"
          class="img-cards m-1" style="height: 155px;width: 124px;object-fit: cover;">
        
        <div class="quantity-overlay" :style="`display: ${selected.includes(shortcode) ? 'flex' : 'none'}`">
          <span x-text="Math.floor(total / selected.length)"></span>
          <svg width="20" height="20" color="white">
            <use xlink:href="<?php echo esc_attr(UPGRAM_URL . 'assets/images/service-symbol-sprite.svg#' . $service_type) ?>" />
          </svg>
        </div>
      </span>
      <template x-if="selected.includes(shortcode)"><input type="hidden" name="post" :value="shortcode"></template>
    </div>
  <?php endforeach; ?>
<?php endif; ?>

<?php if ($posts_next_cursor): ?>
  <div id="load-more-posts-target" class="w-100 view-photo text-center mt-2 pointer">
    <p id="load-more-posts" data-username="<?php echo esc_attr($username) ?>" data-product="<?php echo esc_attr($product_id) ?>" data-cursor="<?php echo esc_attr($posts_next_cursor) ?>">Mostrar mais postagens</p>
  </div>
<?php endif; ?>